TITLE   'Foil Emitting IR Radiation'				         { exa162.pde }
SELECT     							{ Student Edition }
   errlim=1e-5     spectral_colors
COORDINATES
   cartesian1
VARIABLES   temp
DEFINITIONS
   Lx=0.6     Ly=0.4     d=1e-3     k=45                  	{ Steel }
   heat=-2* 0.3*  5.67e-8*(temp^4-300^4)/d		{ Per unit volume }
	   { 2 faces, emissivity, Stefan-Boltzmann formula  }
   fluxd_x=-k*dx(temp)
   equ1=dx( fluxd_x)     equ2=heat
INITIAL VALUES						
   temp=600							{ May be omitted }
EQUATIONS
   dx( fluxd_x)=heat
BOUNDARIES
region 'domain'
   start (0) point value(temp)=1000  line to (Lx) point value(temp)=300
MONITORS
   elevation( temp) from (0,0) to (Lx,0)
PLOTS
   elevation( temp) from (0) to (Lx)
   elevation( equ1, equ2) from (0) to (Lx)	
END

